---
generated_at: 2026-01-21 16:42:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-Test Result Files

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/apex/f141/application/pages/page_00005.sql` (行1-250)
- E-02: `src/plsql/pkg/qa_apex_app_pkg.sql` (行209-295)
- E-03: `src/plsql/pkg/qa_unit_tests_pkg.sql` (行1435-1486)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (行7)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Page IDは5である | E-01（行15: p_id=>5） | ○ |
| C-02 | エイリアスはTEST-RESULT-FILESである | E-01（行17: p_alias=>'TEST-RESULT-FILES'） | ○ |
| C-03 | Protection LevelはCである | E-01（行22: p_protection_level=>'C'） | ○ |
| C-04 | モーダルダイアログである | E-01（行18: p_page_mode=>'MODAL'） | ○ |
| C-05 | P5_XML_FILEはファイルアップロード形式 | E-01（行156: p_display_as=>'NATIVE_FILE'） | ○ |
| C-06 | 許可するファイル形式は.xml | E-01（行163: p_attribute_11=>'.xml'） | ○ |
| C-07 | 表示スタイルはDROPZONE_BLOCK | E-01（行164: p_attribute_12=>'DROPZONE_BLOCK'） | ○ |
| C-08 | Import/Exportリージョンは折りたたみ式 | E-01（行29, 49: is-collapsed） | ○ |
| C-09 | Import処理はqa_apex_app_pkg.p_upload_unit_test_xmlを呼び出す | E-01（行210: process_sql_clob） | ○ |
| C-10 | 成功メッセージは「File imported.」 | E-01（行215: p_process_success_message） | ○ |
| C-11 | p_upload_unit_test_xmlでMIMEタイプを検証 | E-02（行232-235） | ○ |
| C-12 | 無効MIMEタイプのエラーメッセージが定義されている | E-02（行234-235） | ○ |
| C-13 | f_import_test_resultでQA_TEST_RESULTSにINSERT | E-03（行1446-1448） | ○ |
| C-14 | f_export_test_resultでXMLを取得 | E-03（行1473-1476） | ○ |
| C-15 | p_download_unit_test_xmlでHTTPヘッダーを設定 | E-02（行271-277） | ○ |
| C-16 | ダウンロードファイル名形式が定義されている | E-02（行276: 'export_unit_test_results_' || to_char(...) || '.xml'） | ○ |
| C-17 | Export用レポートはQA_TEST_RESULTS_P0005_Vを使用 | E-01（行61: p_query_table=>'QA_TEST_RESULTS_P0005_V'） | ○ |
| C-18 | AutocompleteはOFFに設定 | E-01（行20: p_autocomplete_on_off=>'OFF'） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、ソースコードと完全に整合している

## 6) レビュアーチェックリスト（最小）
- [ ] QA_TEST_RESULTS_P0005_Vビューが正しく定義されているか確認
- [ ] 大きなXMLファイルのインポート・エクスポートパフォーマンスを確認
- [ ] XMLファイルの検証（不正なXML形式への対応）を確認
- [ ] ファイルアップロードのサイズ制限が適切か確認
- [ ] Application Process「getTestResultXMLAttachment」が定義されているか確認
